import request from '@/utils/request'

// 查询Sap特性视图列表
export function pageView(data) {
  return request({
    url: '/md/mdSapField/page',
    method: 'post',
    data
  })
}

// 查询Sap特性视图列表
export function listView(query) {
  return request({
    url: '/md/mdSapField/list',
    method: 'get',
    params: query
  })
}

// 查询Sap特性视图列表
export function listViewVo(query) {
  return request({
    url: '/md/mdSapField/listVo',
    method: 'get',
    params: query
  })
}

// 查询Sap特性视图详细
export function getView(params) {
  return request({
    url: '/md/mdSapField/',
    method: 'get',
    params
  })
}

// 新增Sap特性视图
export function addView(data) {
  return request({
    url: '/md/mdSapField',
    method: 'post',
    data: data
  })
}

// 修改Sap特性视图
export function updateView(data) {
  return request({
    url: '/md/mdSapField',
    method: 'put',
    data: data
  })
}

// 删除Sap特性视图
export function delView(id) {
  return request({
    url: '/md/mdSapField/' + id,
    method: 'delete'
  })
}
