import request from '@/utils/request'

// 查询产品颜色列表
export function listFaceColor(query) {
  return request({
    url: '/mes/md/faceColor/list',
    method: 'get',
    params: query
  })
}

// 查询产品颜色详细
export function getFaceColor(faceColorId) {
  return request({
    url: '/mes/md/faceColor/' + faceColorId,
    method: 'get'
  })
}

// 新增产品颜色
export function addFaceColor(data) {
  return request({
    url: '/mes/md/faceColor',
    method: 'post',
    data: data
  })
}

// 修改产品颜色
export function updateFaceColor(data) {
  return request({
    url: '/mes/md/faceColor',
    method: 'put',
    data: data
  })
}

// 删除产品颜色
export function delFaceColor(mdFaceColorIds) {
  return request({
    url: '/mes/md/faceColor/' + mdFaceColorIds,
    method: 'delete'
  })
}
