import request from '@/utils/request'

// 查询生产方案列表
export function listProductionSolution(query) {
  return request({
    url: 'pro/productionSolution/list',
    method: 'get',
    params: query
  })
}

// 查询生产方案详细
export function getProductionSolution(productionSolutionId) {
  return request({
    url: 'pro/productionSolution/' + productionSolutionId,
    method: 'get'
  })
}

// 新增生产方案
export function addProductionSolution(data) {
  return request({
    url: 'pro/productionSolution',
    method: 'post',
    data: data
  })
}

// 修改生产方案
export function updateProductionSolution(data) {
  return request({
    url: 'pro/productionSolution',
    method: 'put',
    data: data
  })
}

// 删除生产方案
export function delProductionSolution(productionSolutionId) {
  return request({
    url: 'pro/productionSolution/' + productionSolutionId,
    method: 'delete'
  })
}
