import request from "@/utils/request";

// 查询刀模版上下机记录列表
export function listRecord(query) {
  return request({
    url: "/tm/tmToolMachines/warehouse/list",
    method: "get",
    params: query,
  });
}

// 查询刀模版上下机记录详细
export function getRecord(toolMachinesRecordId) {
  return request({
    url: "/tm/tmToolMachinesRecord/" + toolMachinesRecordId,
    method: "get",
  });
}

// 新增刀模版上下机记录
export function addRecord(data) {
  return request({
    url: "/tm/tmToolMachinesRecord",
    method: "post",
    data: data,
  });
}

// 修改入库申请
export function updateRecordWarehouse(data) {
  return request({
    url: "/tm/tmToolMachinesRecord/warehouse ",
    method: "post",
    data: data,
  });
}

// 修改刀模版上下机记录
export function updateRecord(data) {
  return request({
    url: "/tm/tmToolMachinesRecord",
    method: "put",
    data: data,
  });
}

// 删除刀模版上下机记录
export function delRecord(toolMachinesRecordId) {
  return request({
    url: "/tm/tmToolMachinesRecord/" + toolMachinesRecordId,
    method: "delete",
  });
}
