import request from '@/utils/request'

// 查询客户采购订单列表
export function listDetail(query) {
  return request({
    url: '/md/purchaseOrderDetail/list',
    method: 'get',
    params: query
  })
}

// 查询客户采购订单详细
export function getDetail(id) {
  return request({
    url: '/md/purchaseOrderDetail/' + id,
    method: 'get'
  })
}

// 新增客户采购订单
export function addDetail(data) {
  return request({
    url: '/md/purchaseOrderDetail',
    method: 'post',
    data: data
  })
}

// 修改客户采购订单
export function updateDetail(data) {
  return request({
    url: '/md/purchaseOrderDetail',
    method: 'put',
    data: data
  })
}

// 删除客户采购订单
export function delDetail(id) {
  return request({
    url: '/md/purchaseOrderDetail/' + id,
    method: 'delete'
  })
}
