import request from '@/utils/request'

// 查询要维护刀模板列表
export function listMaintenance(query) {
  return request({
    url: '/md/maintenance/list',
    method: 'get',
    params: query
  })
}

// 查询要维护刀模板详细
export function getMaintenance(toolMaintenanceId) {
  return request({
    url: '/md/maintenance/' + toolMaintenanceId,
    method: 'get'
  })
}

// 新增要维护刀模板
export function addMaintenance(data) {
  return request({
    url: '/md/maintenance',
    method: 'post',
    data: data
  })
}

// 修改要维护刀模板
export function updateMaintenance(data) {
  return request({
    url: '/md/maintenance',
    method: 'put',
    data: data
  })
}

// 开始维护刀模板
export function delMaintenance(toolMaintenanceId) {
  return request({
    url: '/md/maintenance/' + toolMaintenanceId,
    method: 'Post'
  })
}
// 删除台账维护
export function delMaintenan(toolMaintenanceId) {
  return request({
    url: '/md/maintenance/' + toolMaintenanceId,
    method: 'delete'
  })
}