import request from '@/utils/request'

// 查询异常信息列表
export function listInformation(query) {
  return request({
    url: '/qc/information/list',
    method: 'get',
    params: query
  })
}

// 查询异常信息详细
export function getInformation(abnormalId) {
  return request({
    url: '/qc/information/' + abnormalId,
    method: 'get'
  })
}

// 新增异常信息
export function addInformation(data) {
  return request({
    url: '/qc/information',
    method: 'post',
    data: data
  })
}

// 修改异常信息
export function updateInformation(data) {
  return request({
    url: '/qc/information',
    method: 'put',
    data: data
  })
}

// 删除异常信息
export function delInformation(abnormalId) {
  return request({
    url: '/qc/information/' + abnormalId,
    method: 'delete'
  })
}
