import request from '@/utils/request'

// 查询生产工单指令列表
export function listWorkOrderSoDirective(query) {
  return request({
    url: '/mes/pro/workOrderSoDirective/list',
    method: 'get',
    params: query
  })
}

// 查询生产工单指令详细
export function getWorkOrderSoDirective(workorderSoDirectiveId) {
  return request({
    url: '/mes/pro/workOrderSoDirective/' + workorderSoDirectiveId,
    method: 'get'
  })
}

// 新增生产工单指令
export function addWorkOrderSoDirective(data) {
  return request({
    url: '/mes/pro/workOrderSoDirective',
    method: 'post',
    data: data
  })
}

// 修改生产工单指令
export function updateWorkOrderSoDirective(data) {
  return request({
    url: '/mes/pro/workOrderSoDirective',
    method: 'put',
    data: data
  })
}

// 删除生产工单指令
export function delWorkOrderSoDirective(workorderSoDirectiveId) {
  return request({
    url: '/mes/pro/workOrderSoDirective/' + workorderSoDirectiveId,
    method: 'delete'
  })
}
