import request from '@/utils/request'

// 查询生产编排单列表
export function listArrange(query) {
  return request({
    url: '/pro/arrange/list',
    method: 'get',
    params: query
  })
}
export function listGroupArrange(query) {
  return request({
    url: '/pro/arrange/groupList',
    method: 'get',
    params: query
  })
}


// 查询生产编排单详细
export function getArrange(arrangeId) {
  return request({
    url: '/pro/arrange/' + arrangeId,
    method: 'get'
  })
}

// 新增生产编排单
export function batchAddArrange(data) {
  return request({
    url: '/pro/arrange/batchAdd',
    method: 'post',
    data: data
  })
}

// 新增生产编排单
export function addArrange(data) {
  return request({
    url: '/pro/arrange',
    method: 'post',
    data: data
  })
}

// 修改生产编排单
export function updateArrange(data) {
  return request({
    url: '/pro/arrange',
    method: 'put',
    data: data
  })
}

// 删除生产编排单
export function delArrange(arrangeId) {
  return request({
    url: '/pro/arrange/' + arrangeId,
    method: 'delete'
  })
}
