import request from '@/utils/request'

// 查询退料申请列表
export function listMaterialReturn(query) {
  return request({
    url: '/pro/materialReturn/list',
    method: 'get',
    params: query
  })
}

// 查询退料申请详细
export function getMaterialReturn(materialReturnId) {
  return request({
    url: '/pro/materialReturn/' + materialReturnId,
    method: 'get'
  })
}

// 新增退料申请
export function addMaterialReturn(data) {
  return request({
    url: '/pro/materialReturn',
    method: 'post',
    data: data
  })
}

// 修改退料申请
export function updateMaterialReturn(data) {
  return request({
    url: '/pro/materialReturn',
    method: 'put',
    data: data
  })
}

// 删除退料申请
export function delMaterialReturn(materialReturnId) {
  return request({
    url: '/pro/materialReturn/' + materialReturnId,
    method: 'delete'
  })
}
