import request from '@/utils/request'

// 查询销售订单原因列表
export function listReason(query) {
  return request({
    url: '/md/reason/list',
    method: 'get',
    params: query
  })
}

// 查询销售订单原因详细
export function getReason(id) {
  return request({
    url: '/md/reason/' + id,
    method: 'get'
  })
}

// 新增销售订单原因
export function addReason(data) {
  return request({
    url: '/md/reason',
    method: 'post',
    data: data
  })
}

// 修改销售订单原因
export function updateReason(data) {
  return request({
    url: '/md/reason',
    method: 'put',
    data: data
  })
}

// 删除销售订单原因
export function delReason(id) {
  return request({
    url: '/md/reason/' + id,
    method: 'delete'
  })
}
