import request from '@/utils/request'

// 查询产品工厂配置列表
export function listFactory(query) {
  return request({
    url: '/md/factory/list',
    method: 'get',
    params: query
  })
}

// 查询产品工厂配置详细
export function getFactory(productFactoryId) {
  return request({
    url: '/md/factory/' + productFactoryId,
    method: 'get'
  })
}

// 新增产品工厂配置
export function addFactory(data) {
  return request({
    url: '/md/factory',
    method: 'post',
    data: data
  })
}

// 修改产品工厂配置
export function updateFactory(data) {
  return request({
    url: '/md/factory',
    method: 'put',
    data: data
  })
}

// 删除产品工厂配置
export function delFactory(productFactoryId) {
  return request({
    url: '/md/factory/' + productFactoryId,
    method: 'delete'
  })
}
