import request from '@/utils/request'

// 查询量产制作工序物料列表
export function listProductionMakeProcessItem(query) {
  return request({
    url: '/md/productionMakeProcessItem/list',
    method: 'get',
    params: query
  })
}

// 查询量产制作工序物料详细
export function getProductionMakeProcessItem(productionMakeProcessItemId) {
  return request({
    url: '/md/productionMakeProcessItem/' + productionMakeProcessItemId,
    method: 'get'
  })
}

// 新增量产制作工序物料
export function addProductionMakeProcessItem(data) {
  return request({
    url: '/md/productionMakeProcessItem',
    method: 'post',
    data: data
  })
}

// 修改量产制作工序物料
export function updateProductionMakeProcessItem(data) {
  return request({
    url: '/md/productionMakeProcessItem',
    method: 'put',
    data: data
  })
}

// 删除量产制作工序物料
export function delProductionMakeProcessItem(productionMakeProcessItemId) {
  return request({
    url: '/md/productionMakeProcessItem/' + productionMakeProcessItemId,
    method: 'delete'
  })
}
