import request from '@/utils/request'

// 查询销售订单装运点列表
export function listPoint(query) {
  return request({
    url: '/md/point/list',
    method: 'get',
    params: query
  })
}

// 查询销售订单装运点详细
export function getPoint(id) {
  return request({
    url: '/md/point/' + id,
    method: 'get'
  })
}

// 新增销售订单装运点
export function addPoint(data) {
  return request({
    url: '/md/point',
    method: 'post',
    data: data
  })
}

// 修改销售订单装运点
export function updatePoint(data) {
  return request({
    url: '/md/point',
    method: 'put',
    data: data
  })
}

// 删除销售订单装运点
export function delPoint(id) {
  return request({
    url: '/md/point/' + id,
    method: 'delete'
  })
}
