import request from '@/utils/request'

// 查询客户付款信息关联列表
export function listRelation(query) {
  return request({
    url: '/md/clientPaymentRelation/list',
    method: 'get',
    params: query
  })
}

// 查询客户付款信息关联详细
export function getRelation(id) {
  return request({
    url: '/md/clientPaymentRelation/' + id,
    method: 'get'
  })
}

// 新增客户付款信息关联
export function addRelation(data) {
  return request({
    url: '/md/clientPaymentRelation',
    method: 'post',
    data: data
  })
}

// 修改客户付款信息关联
export function updateRelation(data) {
  return request({
    url: '/md/clientPaymentRelation',
    method: 'put',
    data: data
  })
}

// 删除客户付款信息关联
export function delRelation(id) {
  return request({
    url: '/md/clientPaymentRelation/' + id,
    method: 'delete'
  })
}
