import request from '@/utils/request'

// 查询领料申请列表
export function listMaterialRequest(query) {
  return request({
    url: '/pro/materialRequest/list',
    method: 'get',
    params: query
  })
}

// 查询领料申请详细
export function getMaterialRequest(materialRequestId) {
  return request({
    url: '/pro/materialRequest/' + materialRequestId,
    method: 'get'
  })
}

// 新增领料申请
export function addMaterialRequest(data) {
  return request({
    url: '/pro/materialRequest',
    method: 'post',
    data: data
  })
}

// 修改领料申请
export function updateMaterialRequest(data) {
  return request({
    url: '/pro/materialRequest',
    method: 'put',
    data: data
  })
}

// 删除领料申请
export function delMaterialRequest(materialRequestId) {
  return request({
    url: '/pro/materialRequest/' + materialRequestId,
    method: 'delete'
  })
}
