import request from '@/utils/request'

// 查询生产编排单列表
export function getListData(query) {
  return request({
    url: `/mes/pro/taskWorkunit/list?pageNum=${query.pageNum}&pageSize=${query.pageSize}`,
    method: "post",
    data: query,
  });
}

// 修改生产任务数据
export function updateList(query) {
  return request({
    url: "/mes/pro/taskWorkunit/updateTimeAndWorkunit",
    method: "post",
    data: query
  });
}
// 下达生产
export function makeProduction(query) {
  return request({
    url: "/mes/pro/taskWorkunit/makeProduction",
    method: "post",
    data: query
  });
}

// 排程
export function makeSchedule(query) {
  return request({
    url: "/mes/pro/protask/schedule",
    method: "post",
    data: query,
    timeout: 120000
  });
}

// 关联工单表查询编排表（合并重复项）
export function arrangeList(query) {
  return request({
    url: "/pro/arrange/list2",
    method: "post",
    data: query,
  });
}

// 关联工单表查询编排表（合并重复项）
export function distinctList(query) {
  return request({
    url: "/pro/arrange/distinctList",
    method: "post",
    data: query,
  });
}

// 查询任务工作单元列表
export function taskWorkunitList(query) {
  return request({
    url: "/mes/pro/taskWorkunit/workorderList",
    method: "post",
    data: query
  });
}

// 车间列表查询
export function getworkshopList(query) {
  // workshopId workshopName
  return request({
    url: "/mes/md/workshop/list",
    method: "get"
  });
}

// 工作中心查询
export function getworkstationList(query) {
  // workshopId workstationId workstationName
  return request({
    url: "/mes/md/workstation/list",
    method: "get",
    params: query
  });
}

// 查询任务工作单元列表
export function gettaskWorkunitList(query) {
  // workshopId workCenterId = workstationId workstationName  workunitId workunitName
  return request({
    url: "md/workunit/list",
    method: "get",
    params: query,
  });
}

// 默认工作中心查询
export function getdefaultWorkCenterList() {
  // workshopId workCenterId = workstationId workstationName  workunitId workunitName
  return request({
    url: "/mes/md/workstation/defaultList",
    method: "get"
  });
}

// 获取完工的任务
export function listFinishTaskWorkunits(query) {
  return request({
    url: "/mes/pro/taskWorkunit/listFinishTaskWorkunits",
    method: "get",
    params: query
  });
}
// 打开完工的任务
export function openTaskWorkunit(id) {
  return request({
    url: "/mes/pro/taskWorkunit/openTaskWorkunit/" + id,
    method: "get"
  });
}

