import request from '@/utils/request'

// 查询销售订单列表
export function listOrder(query) {
  return request({
    url: '/od/salesOrder/list',
    method: 'get',
    params: query
  })
}

// 查询销售订单详细
export function getOrder(id) {
  return request({
    url: '/od/salesOrder/' + id,
    method: 'get'
  })
}

// 查询销售订单详细
export function getSapInfo(id) {
  return request({
    url: '/od/salesOrder/getSapInfo/' + id,
    method: 'get'
  })
}

// 查询销售订单详细
export function getOrderDetail(params) {
  return request({
    url: '/od/salesOrder/detail',
    method: 'get',
    params
  })
}

// 新增销售订单
export function addOrder(data) {
  return request({
    url: '/od/salesOrder',
    method: 'post',
    data: data
  })
}

// 修改销售订单
export function updateOrder(data) {
  return request({
    url: '/od/salesOrder',
    method: 'put',
    data: data
  })
}

// 同步销售订单
export function syncOrder(id) {
  return request({
    url: '/od/salesOrder/sync/' + id,
    method: 'get'
  })
}

// 删除销售订单
export function delOrder(id) {
  return request({
    url: '/od/salesOrder/' + id,
    method: 'delete'
  })
}
