import request from '@/utils/request'

// 查询车间异常单列表
export function listReport(query) {
  return request({
    url: '/qc/report/list',
    method: 'get',
    params: query
  })
}

// 获取原物料
export function getAllBomMaterial(id, query) {
  return request({
    url: '/qc/report/getAllBomMaterial/' + id,
    method: 'get',
    params: query
  })
}
// 获取原工序
export function getAllProcess(id) {
  return request({
    url: '/qc/report/getAllProcess/' + id,
    method: 'get'
  })
}
// 查询车间异常单详细
export function getReport(abnormalReportId) {
  return request({
    url: '/qc/report/' + abnormalReportId,
    method: 'get'
  })
}

// 新增车间异常单
export function addReport(data) {
  return request({
    url: '/qc/report',
    method: 'post',
    data: data
  })
}

// 修改车间异常单
export function updateReport(data) {
  return request({
    url: '/qc/report',
    method: 'put',
    data: data
  })
}

// 删除车间异常单
export function delReport(abnormalReportId) {
  return request({
    url: '/qc/report/' + abnormalReportId,
    method: 'delete'
  })
}

  // 完成按钮功能
export function completeReport(abnormalReportId) {
  return request({
    url: '/qc/report/complete/' + abnormalReportId,
    method: 'put'
  })
}

  // 提交功能
  export function submit(id) {
    return request({
      url: '/qc/report/submit/' + id,
      method: 'put'
    })
  }