import request from '@/utils/request'

// 查询销售单位转换列表
export function listUnit(query) {
  return request({
    url: '/md/unit/list',
    method: 'get',
    params: query
  })
}

// 查询销售单位转换详细
export function getUnit(id) {
  return request({
    url: '/md/unit/' + id,
    method: 'get'
  })
}

// 新增销售单位转换
export function addUnit(data) {
  return request({
    url: '/md/unit',
    method: 'post',
    data: data
  })
}

// 修改销售单位转换
export function updateUnit(data) {
  return request({
    url: '/md/unit',
    method: 'put',
    data: data
  })
}

// 删除销售单位转换
export function delUnit(id) {
  return request({
    url: '/md/unit/' + id,
    method: 'delete'
  })
}
