import request from '@/utils/request'

// 查询列表
export function listPropertyDict(query) {
  return request({
    url: '/md/propertydict/list',
    method: 'get',
    params: query
  })
}

// 查询详细
export function getPropertyDict(id) {
  return request({
    url: '/md/propertydict/' + id,
    method: 'get'
  })
}

// 新增
export function addPropertyDict(data) {
  return request({
    url: '/md/propertydict',
    method: 'post',
    data: data
  })
}

// 修改
export function updatePropertyDict(data) {
  return request({
    url: '/md/propertydict',
    method: 'put',
    data: data
  })
}

// 删除
export function delPropertyDict(id) {
  return request({
    url: '/md/propertydict/' + id,
    method: 'delete'
  })
}
