import request from '@/utils/request'

// 查询打印机配置列表
export function listPrinterConfig(query) {
  return request({
    url: '/system/printerConfig/list',
    method: 'get',
    params: query
  })
}

// 查询打印机配置详细
export function getPrinterConfig(printerId) {
  return request({
    url: '/system/printerConfig/' + printerId,
    method: 'get'
  })
}

// 新增打印机配置
export function addPrinterConfig(data) {
  return request({
    url: '/system/printerConfig',
    method: 'post',
    data: data
  })
}

// 修改打印机配置
export function updatePrinterConfig(data) {
  return request({
    url: '/system/printerConfig',
    method: 'put',
    data: data
  })
}

// 删除打印机配置
export function delPrinterConfig(printerId) {
  return request({
    url: '/system/printerConfig/' + printerId,
    method: 'delete'
  })
}
