import request from '@/utils/request'

// 查询样品制作BOM列表
export function listPrototypeMakeBom(query) {
  return request({
    url: '/mes/pro/prototypeMakeBom/list',
    method: 'get',
    params: query
  })
}

// 查询样品制作BOM详细
export function getPrototypeMakeBom(bomItemId) {
  return request({
    url: '/mes/pro/prototypeMakeBom/' + bomItemId,
    method: 'get'
  })
}

// 新增样品制作BOM
export function addPrototypeMakeBom(data) {
  return request({
    url: '/mes/pro/prototypeMakeBom',
    method: 'post',
    data: data
  })
}

// 修改样品制作BOM
export function updatePrototypeMakeBom(data) {
  return request({
    url: '/mes/pro/prototypeMakeBom',
    method: 'put',
    data: data
  })
}

// 删除样品制作BOM
export function delPrototypeMakeBom(bomItemId) {
  return request({
    url: '/mes/pro/prototypeMakeBom/' + bomItemId,
    method: 'delete'
  })
}
