import request from '@/utils/request'

// 查询列表
export function listSapproperty(query) {
  return request({
    url: '/md/sapproperty/list',
    method: 'get',
    params: query
  })
}
// 查询列表
export function listByType(query) {
  return request({
    url: '/md/sapproperty/listByType',
    method: 'get',
    params: query
  })
}

// 查询详细
export function getSapproperty(clientId) {
  return request({
    url: '/md/sapproperty/' + clientId,
    method: 'get'
  })
}

// 新增
export function addSapproperty(data) {
  return request({
    url: '/md/sapproperty',
    method: 'post',
    data: data
  })
}

// 修改
export function updateSapproperty(data) {
  return request({
    url: '/md/sapproperty',
    method: 'put',
    data: data
  })
}

// 删除
export function delSapproperty(clientId) {
  return request({
    url: '/md/sapproperty/' + clientId,
    method: 'delete'
  })
}
