import request from '@/utils/request'

// 查询品牌联系人列表
export function listContact(query) {
  return request({
    url: '/md/contact/list',
    method: 'get',
    params: query
  })
}

// 查询品牌联系人详细
export function getContact(brandContactId) {
  return request({
    url: '/md/contact/' + brandContactId,
    method: 'get'
  })
}

// 新增品牌联系人
export function addContact(data) {
  return request({
    url: '/md/contact',
    method: 'post',
    data: data
  })
}

// 修改品牌联系人
export function updateContact(data) {
  return request({
    url: '/md/contact',
    method: 'put',
    data: data
  })
}

// 删除品牌联系人
export function delContact(brandContactId) {
  return request({
    url: '/md/contact/' + brandContactId,
    method: 'delete'
  })
}

// 查询品牌列表（不传参查所有）
export function listBrand(query) {
  return request({
    url: '/md/contact/listBrand',
    method: 'get',
    params: query
  })
}
