import request from '@/utils/request'

// 查询刀模板物料领用单列表
export function listTmToolRequestUseItem(query) {
  return request({
    url: '/tm/tmToolRequestUseItem/list',
    method: 'get',
    params: query
  })
}

// 查询刀模板物料领用单详细
export function getTmToolRequestUseItem(toolRequestUseItemId) {
  return request({
    url: '/tm/tmToolRequestUseItem/' + toolRequestUseItemId,
    method: 'get'
  })
}

// 新增刀模板物料领用单
export function addTmToolRequestUseItem(data) {
  return request({
    url: '/tm/tmToolRequestUseItem',
    method: 'post',
    data: data
  })
}

// 修改刀模板物料领用单
export function updateTmToolRequestUseItem(data) {
  return request({
    url: '/tm/tmToolRequestUseItem',
    method: 'put',
    data: data
  })
}

// 删除刀模板物料领用单
export function delTmToolRequestUseItem(toolRequestUseItemId) {
  return request({
    url: '/tm/tmToolRequestUseItem/' + toolRequestUseItemId,
    method: 'delete'
  })
}
