import request from '@/utils/request'

// 查询订单 交易币别列表
export function listCurrency(query) {
  return request({
    url: '/md/currency/list',
    method: 'get',
    params: query
  })
}

// 查询订单 交易币别详细
export function getCurrency(id) {
  return request({
    url: '/md/currency/' + id,
    method: 'get'
  })
}

// 新增订单 交易币别
export function addCurrency(data) {
  return request({
    url: '/md/currency',
    method: 'post',
    data: data
  })
}

// 修改订单 交易币别
export function updateCurrency(data) {
  return request({
    url: '/md/currency',
    method: 'put',
    data: data
  })
}

// 删除订单 交易币别
export function delCurrency(id) {
  return request({
    url: '/md/currency/' + id,
    method: 'delete'
  })
}
