import request from "@/utils/request";

// 查询生产版本BOM列表
export function listProductionSolutionBom(query) {
  return request({
    url: "/mes/pro/productionSolutionBom/list",
    method: "get",
    params: query,
  });
}

// 查询生产版本BOM详细
export function getProductionSolutionBom(bomItemId) {
  return request({
    url: "/mes/pro/productionSolutionBom/" + bomItemId,
    method: "get",
  });
}

// 新增生产版本BOM
export function addProductionSolutionBom(data) {
  return request({
    url: "/mes/pro/productionSolutionBom",
    method: "post",
    data: data,
  });
}

// 修改生产版本BOM
export function updateProductionSolutionBom(data) {
  return request({
    url: "/mes/pro/productionSolutionBom",
    method: "put",
    data: data,
  });
}

// 删除生产版本BOM
export function delProductionSolutionBom(bomItemId) {
  return request({
    url: "/mes/pro/productionSolutionBom/" + bomItemId,
    method: "delete",
  });
}
