import request from '@/utils/request'

// 查询销售订单办事处列表
export function listOffice(query) {
  return request({
    url: '/md/office/list',
    method: 'get',
    params: query
  })
}

// 查询销售订单办事处详细
export function getOffice(id) {
  return request({
    url: '/md/office/' + id,
    method: 'get'
  })
}

// 新增销售订单办事处
export function addOffice(data) {
  return request({
    url: '/md/office',
    method: 'post',
    data: data
  })
}

// 修改销售订单办事处
export function updateOffice(data) {
  return request({
    url: '/md/office',
    method: 'put',
    data: data
  })
}

// 删除销售订单办事处
export function delOffice(id) {
  return request({
    url: '/md/office/' + id,
    method: 'delete'
  })
}
