import request from '@/utils/request'

// 查询客户付款信息列表
export function pageAccount(data) {
  return request({
    url: '/md/mdClientAccount/page',
    method: 'post',
    data
  })
}

// 查询客户付款信息列表
export function listAccount(query) {
  return request({
    url: '/md/mdClientAccount/list',
    method: 'get',
    params: query
  })
}

// 查询客户付款信息详细
export function getAccount(id) {
  return request({
    url: '/md/mdClientAccount/' + id,
    method: 'get'
  })
}

// 新增客户付款信息
export function addAccount(data) {
  return request({
    url: '/md/mdClientAccount',
    method: 'post',
    data: data
  })
}

// 修改客户付款信息
export function updateAccount(data) {
  return request({
    url: '/md/mdClientAccount',
    method: 'put',
    data: data
  })
}

// 删除客户付款信息
export function delAccount(id) {
  return request({
    url: '/md/mdClientAccount/' + id,
    method: 'delete'
  })
}
