import request from '@/utils/request'

// 查询品牌列表
export function listBrand(query) {
  return request({
    url: '/mes/md/brand/list',
    method: 'get',
    params: query
  })
}

// 查询所有品牌
export function listAllBrand(query) {
  return request({
    url: '/mes/md/brand/listAll',
    method: 'get' ,
    params: query
  })
}


// 根据条件查询查询品牌列表
export function listBrandByCondition(query) {
  return request({
    url: '/mes/md/brand/listBrandByCondition',
    method: 'get',
    params: query
  })
}


// 查询品牌详细
export function getBrand(brandId) {
  return request({
    url: '/mes/md/brand/' + brandId,
    method: 'get'
  })
}

// 新增品牌
export function addBrand(data) {
  return request({
    url: '/mes/md/brand',
    method: 'post',
    data: data
  })
}

// 修改品牌
export function updateBrand(data) {
  return request({
    url: '/mes/md/brand',
    method: 'put',
    data: data
  })
}

// 删除品牌
export function delBrand(brandId) {
  return request({
    url: '/mes/md/brand/' + brandId,
    method: 'delete'
  })
}
