import request from '@/utils/request'

// 查询客户产品对照列表
export function listItem(query) {
  return request({
    url: '/md/clientItem/list',
    method: 'post',
    data: query
  })
}

// 查询客户产品对照详细
export function getItem(id) {
  return request({
    url: '/md/clientItem/' + id,
    method: 'get'
  })
}

// 新增客户产品对照
export function addItem(data) {
  return request({
    url: '/md/clientItem',
    method: 'post',
    data: data
  })
}

// 修改客户产品对照
export function updateItem(data) {
  return request({
    url: '/md/clientItem',
    method: 'put',
    data: data
  })
}

// 删除客户产品对照
export function delItem(id) {
  return request({
    url: '/md/clientItem/' + id,
    method: 'delete'
  })
}
