import request from '@/utils/request'

// 查询刀模版上下机记录列表
export function listTmToolMachinesRecord(query) {
  return request({
    url: '/tm/tmToolMachinesRecord/list',
    method: 'get',
    params: query
  })
}

// 查询刀模版上下机记录详细
export function getTmToolMachinesRecord(toolMachinesRecordId) {
  return request({
    url: '/tm/tmToolMachinesRecord/' + toolMachinesRecordId,
    method: 'get'
  })
}

// 新增刀模版上下机记录
export function addTmToolMachinesRecord(data) {
  return request({
    url: '/tm/tmToolMachinesRecord',
    method: 'post',
    data: data
  })
}

// 修改刀模版上下机记录
export function updateTmToolMachinesRecord(data) {
  return request({
    url: '/tm/tmToolMachinesRecord',
    method: 'put',
    data: data
  })
}

// 删除刀模版上下机记录
export function delTmToolMachinesRecord(toolMachinesRecordId) {
  return request({
    url: '/tm/tmToolMachinesRecord/' + toolMachinesRecordId,
    method: 'delete'
  })
}
