import request from '@/utils/request'

// 查询质检用户列表
export function getListApi(query) {
  return request({
    url: '/md/qc/workstationqc/user/list',
    method: 'get',
    params: query
  })
}

// 查询工作中心列表
export function getWorkListApi(query) {
  return request({
    url: '/mes/md/workstation/list',
    method: 'get',
    params: query
  })
}

// 查询质检用户详情
export function getDetailApi(query) {
  return request({
    url: '/md/qc/workstationqc/user',
    method: 'get',
    params: query
  })
}

// 新增用户权限
export function addWorkAuthApi(data) {
  return request({
    url: '/md/qc/workstationqc/',
    method: 'post',
    data: data
  })
}

// 删除用户权限
export function deleteWorkAuthApi(id) {
  console.log(id);
  return request({
    url: '/md/qc/workstationqc/' + id,
    method: 'delete'
  })
}

// 更改管理员权限
export function changeManagerApi(data) {
  return request({
    url: '/md/qc/workstationqc/changeManager',
    method: 'post',
    data: data
  })
}
