import request from '@/utils/request'

// 查询工单变更记录列表
export function listRecord(query) {
  return request({
    url: '/md/record/list',
    method: 'get',
    params: query
  })
}

// 查询工单变更记录详细
export function getRecord(id) {
  return request({
    url: '/md/record/' + id,
    method: 'get'
  })
}

// 新增工单变更记录
export function addRecord(data) {
  return request({
    url: '/md/record',
    method: 'post',
    data: data
  })
}

// 修改工单变更记录
export function updateRecord(data) {
  return request({
    url: '/md/record',
    method: 'put',
    data: data
  })
}

// 删除工单变更记录
export function delRecord(id) {
  return request({
    url: '/md/record/' + id,
    method: 'delete'
  })
}
