import request from '@/utils/request'

// 查询样品制作工序物料列表
export function listPrototypeMakeProcessItem(query) {
  return request({
    url: '/mes/pro/prototypeMakeProcessItem/list',
    method: 'get',
    params: query
  })
}

// 查询样品制作工序物料详细
export function getPrototypeMakeProcessItem(prototypeMakeProcessItemId) {
  return request({
    url: '/mes/pro/prototypeMakeProcessItem/' + prototypeMakeProcessItemId,
    method: 'get'
  })
}

// 新增样品制作工序物料
export function addPrototypeMakeProcessItem(data) {
  return request({
    url: '/mes/pro/prototypeMakeProcessItem',
    method: 'post',
    data: data
  })
}

// 修改样品制作工序物料
export function updatePrototypeMakeProcessItem(data) {
  return request({
    url: '/mes/pro/prototypeMakeProcessItem',
    method: 'put',
    data: data
  })
}

// 删除样品制作工序物料
export function delPrototypeMakeProcessItem(prototypeMakeProcessItemId) {
  return request({
    url: '/mes/pro/prototypeMakeProcessItem/' + prototypeMakeProcessItemId,
    method: 'delete'
  })
}
