import request from "@/utils/request";

// 查询生产任务列表
export function listProtask(query) {
  return request({
    url: "/mes/pro/protask/list",
    method: "get",
    params: query,
  });
}

// 查询生产任务列表
export function listProtasks(query) {
  return request({
    url: "/mes/pro/protask/lists",
    method: "get",
    params: query,
  });
}

// 查询生产任务列表
export function listGanttTaskList(query) {
  return request({
    url: "/mes/pro/protask/listGanttTaskList",
    method: "get",
    params: query,
  });
}

// 作业分派
export function putProtaskSplit(query) {
  return request({
    url: "/mes/pro/protask/split",
    method: "put",
    data: query,
  });
}

// 查询生产任务列表加上了字段workunitName
export function listTaskListDetail(query) {
  return request({
    url: "/mes/pro/protask/listDetail",
    method: "get",
    params: query,
  });
}
// 查询根据任务id获取刀模版
export function getTaskIdMaxProcessTool(query) {
  const params = Object.assign({}, query)
  const id = query.taskId;
  delete params.taskId
  return request({
    url: `/mes/pro/protask/getToolOnUseTemplate/${id}`,
    method: "get",
    params,
  });
}

// 查询生产任务详细
export function getProtask(taskId) {
  return request({
    url: "/mes/pro/protask/" + taskId,
    method: "get",
  });
}

// 新增生产任务
export function addProtask(data) {
  return request({
    url: "/mes/pro/protask",
    method: "post",
    data: data,
  });
}

// 修改生产任务
export function updateProtask(data) {
  return request({
    url: "/mes/pro/protask",
    method: "put",
    data: data,
  });
}

// 删除生产任务
export function delProtask(taskId) {
  return request({
    url: "/mes/pro/protask/" + taskId,
    method: "delete",
  });
}

// 生成任务单、合并任务单
export function addProtaskList(workorderIds) {
  return request({
    url: "/mes/pro/protask/" + workorderIds,
    method: "post",
  });
}

// 工站变更
export function splitWorkstation(data) {
  return request({
    url: "/mes/pro/protask/splitWorkstation",
    method: "put",
    data: data,
  });
}

// 工序删除
export function deleteTask(taskId) {
  return request({
    url: "/mes/pro/protask/deleteTask/" + taskId,
    method: "delete",
  });
}

// 校验状态改变
export function updateNotInspectionStatusApi(data) {
  return request({
    url: `/tm/tmToolRequest/updateNotInspectionStatus/${data.toolRequestItemId}?inspectionStatus=${data.inspectionStatus}`,
    method: "put",
  });
}

// 虚拟报工
export function updateProTaskWorkunitApi(data) {
  return request({
    url: `/mes/pro/taskWorkunit/updateProTaskWorkunit/${data.taskWorkunitId}?virtualFlag=${data.virtualFlag}`,
    method: "post",
  });
}