import request from "@/utils/request";

// 查询生产版本工序列表
export function listProductionSolutionProcess(query) {
  return request({
    url: "/mes/pro/productionSolutionProcess/list",
    method: "get",
    params: query,
  });
}

// 查询生产版本工序详细
export function getProductionSolutionProcess(productionSolutionProcessId) {
  return request({
    url: "/mes/pro/productionSolutionProcess/" + productionSolutionProcessId,
    method: "get",
  });
}

// 新增生产版本工序
export function addProductionSolutionProcess(data) {
  return request({
    url: "/mes/pro/productionSolutionProcess",
    method: "post",
    data: data,
  });
}

// 修改生产版本工序
export function updateProductionSolutionProcess(data) {
  return request({
    url: "/mes/pro/productionSolutionProcess",
    method: "put",
    data: data,
  });
}

// 删除生产版本工序
export function delProductionSolutionProcess(productionSolutionProcessId) {
  return request({
    url: "/mes/pro/productionSolutionProcess/" + productionSolutionProcessId,
    method: "delete",
  });
}
