import request from '@/utils/request'

// 查询dta信息列表
export function getDtaList(query) {
  return request({
    url: "/md/dta/record/list",
    method: "get",
    params: query,
  });
}


// 修改dta信息
export function finishApi(data) {
  return request({
    url: `/md/dta/record/confirm/${data}`,
    method: "put"
  });
}

// 修改dta信息
export function cancelApi(data) {
  return request({
    url: `/md/dta/record/cancel/${data}`,
    method: "put"
  });
}

// 查询唯一码号段
export function getLPNrecordList(query) {
  return request({
    url: "/pro/serial/record/list",
    method: "get",
    params: query,
  });
}


// 批量删除记录
export function markDelete(id) {
  return request({
    url: '/pro/serial/record/markDelete/' + id,
    method: 'delete'
  })
}

// 批量取消删除记录
export function unMarkDelete(id) {
  return request({
    url: '/pro/serial/record/unMarkDelete/' + id,
    method: 'delete'
  })
}