import request from '@/utils/request'

// 查询列表
export function listCustomerLabel(query) {
  return request({
    url: '/pro/customerLabel/getList',
    method: 'get',
    params: query
  })
}

// 修改列表
export function updateCustomerLabel(data) {
  return request({
    url: '/pro/customerLabel/update',
    method: 'post',
    data: data
  })
}

// 新增列表
export function addCustomerLabel(data) {
    return request({
      url: '/pro/customerLabel/save',
      method: 'post',
      data: data
    })
  }

// 删除列表
export function delcustomerLabel(id) {
  return request({
    url: '/pro/customerLabel/delete/' + id,
    method: 'delete'
  })
}
// 客户下拉框
export function getMmPlnrPlnr(id) {
    return request({
      url: '/pro/customerLabel/getMmPlnrPlnr',
      method: 'get'
    })
}

// 品牌下拉框
export function getBrand(id) {
    return request({
      url: '/pro/customerLabel/getBrand',
      method: 'get'
    })
}