import request from '@/utils/request'

// 查询列表
export function list(query) {
  return request({ url: '/md/sapDictData/list', method: 'get', params: query })
}
// 查询列表
export function page(params) {
  return request({ url: '/md/sapDictData/page', method: 'get', params })
}

// 查询详细
export function get(id) {
  return request({ url: '/md/sapDictData/' + id, method: 'get' })
}

// 新增
export function add(data) {
  return request({ url: '/md/sapDictData', method: 'post', data: data })
}

// 修改
export function update(data) {
  return request({ url: '/md/sapDictData', method: 'put', data: data })
}

// 删除
export function del(id) {
  return request({ url: '/md/sapDictData/' + id, method: 'delete' })
}
