import request from '@/utils/request'

// 查询销售订单类型列表
export function listType(query) {
  return request({
    url: '/md/type/list',
    method: 'get',
    params: query
  })
}

// 查询销售订单类型详细
export function getType(id) {
  return request({
    url: '/md/type/' + id,
    method: 'get'
  })
}

// 新增销售订单类型
export function addType(data) {
  return request({
    url: '/md/type',
    method: 'post',
    data: data
  })
}

// 修改销售订单类型
export function updateType(data) {
  return request({
    url: '/md/type',
    method: 'put',
    data: data
  })
}

// 删除销售订单类型
export function delType(id) {
  return request({
    url: '/md/type/' + id,
    method: 'delete'
  })
}
