import request from '@/utils/request'

// 查询催货款通知邮箱列表
export function listEmail(query) {
  return request({
    url: '/md/clientUrgeEmail/list',
    method: 'get',
    params: query
  })
}

// 查询催货款通知邮箱详细
export function getEmail(id) {
  return request({
    url: '/md/clientUrgeEmail/' + id,
    method: 'get'
  })
}

// 新增催货款通知邮箱
export function addEmail(data) {
  return request({
    url: '/md/clientUrgeEmail',
    method: 'post',
    data: data
  })
}

// 修改催货款通知邮箱
export function updateEmail(data) {
  return request({
    url: '/md/clientUrgeEmail',
    method: 'put',
    data: data
  })
}

// 删除催货款通知邮箱
export function delEmail(id) {
  return request({
    url: '/md/clientUrgeEmail/' + id,
    method: 'delete'
  })
}
