import request from '@/utils/request'

// 查询调拨料申请列表
export function listProAllocationMaterial(query) {
  return request({
    url: '/pro/ProAllocationMaterial/list',
    method: 'get',
    params: query
  })
}

// 查询调拨料申请详细
export function getProAllocationMaterial(allocationMaterialId) {
  return request({
    url: '/pro/ProAllocationMaterial/' + allocationMaterialId,
    method: 'get'
  })
}

// 新增调拨料申请
export function addProAllocationMaterial(data) {
  return request({
    url: '/pro/ProAllocationMaterial',
    method: 'post',
    data: data
  })
}

// 修改调拨料申请
export function updateProAllocationMaterial(data) {
  return request({
    url: '/pro/ProAllocationMaterial',
    method: 'put',
    data: data
  })
}

// 删除调拨料申请
export function delProAllocationMaterial(allocationMaterialId) {
  return request({
    url: '/pro/ProAllocationMaterial/' + allocationMaterialId,
    method: 'delete'
  })
}
