import request from '@/utils/request'

// 查询工作中心发料申请列表
export function listMaterial(query) {
  return request({
    url: '/pro/material/list',
    method: 'get',
    params: query
  })
}

// 查询工作中心发料申请详细
export function getMaterial(workstationMaterialId) {
  return request({
    url: '/pro/material/' + workstationMaterialId,
    method: 'get'
  })
}

// 新增工作中心发料申请
export function addMaterial(data) {
  return request({
    url: '/pro/material',
    method: 'post',
    data: data
  })
}

// 修改工作中心发料申请
export function updateMaterial(data) {
  return request({
    url: '/pro/material',
    method: 'put',
    data: data
  })
}

// 删除工作中心发料申请
export function delMaterial(workstationMaterialId) {
  return request({
    url: '/pro/material/' + workstationMaterialId,
    method: 'delete'
  })
}
