import request from '@/utils/request'

// 查询颜色主数据列表
export function listColor(query) {
  return request({
    url: '/md/color/list',
    method: 'get',
    params: query
  })
}

// 查询颜色主数据详细
export function getColor(colorId) {
  return request({
    url: '/md/color/' + colorId,
    method: 'get'
  })
}

// 新增颜色主数据
export function addColor(data) {
  return request({
    url: '/md/color',
    method: 'post',
    data: data
  })
}

// 修改颜色主数据
export function updateColor(data) {
  return request({
    url: '/md/color',
    method: 'put',
    data: data
  })
}

// 删除颜色主数据
export function delColor(colorId) {
  return request({
    url: '/md/color/' + colorId,
    method: 'delete'
  })
}
