import request from '@/utils/request'

// 查询国际贸易销售条款列表
export function listClause(query) {
  return request({
    url: '/md/clause/list',
    method: 'get',
    params: query
  })
}

// 查询国际贸易销售条款详细
export function getClause(id) {
  return request({
    url: '/md/clause/' + id,
    method: 'get'
  })
}

// 新增国际贸易销售条款
export function addClause(data) {
  return request({
    url: '/md/clause',
    method: 'post',
    data: data
  })
}

// 修改国际贸易销售条款
export function updateClause(data) {
  return request({
    url: '/md/clause',
    method: 'put',
    data: data
  })
}

// 删除国际贸易销售条款
export function delClause(id) {
  return request({
    url: '/md/clause/' + id,
    method: 'delete'
  })
}
