import request from '@/utils/request'

// 查询来料检验单列表
export function listIqc(query) {
  return request({
    url: '/mes/qc/iqc/list',
    method: 'get',
    params: query
  })
}

// 查询来料检验单详细
export function getIqc(iqcId) {
  return request({
    url: '/mes/qc/iqc/' + iqcId,
    method: 'get'
  })
}

// 新增来料检验单
export function addIqc(data) {
  return request({
    url: '/mes/qc/iqc',
    method: 'post',
    data: data
  })
}

// 打印iqc检验单
export function printIqc(id) {
  return request({
    url: '/mes/qc/iqc/' + id,
    method: 'get'
  })
}

// 修改来料检验单
export function updateIqc(data) {
  return request({
    url: '/mes/qc/iqc',
    method: 'put',
    data: data
  })
}

// 删除来料检验单
export function delIqc(iqcId) {
  return request({
    url: '/mes/qc/iqc/' + iqcId,
    method: 'delete'
  })
}

export function getpclist(query) {
  return request({
    url: '/mes/qc/iqc/pclist',
    method: 'post',
    data: query
  })
}

export function getcheckResult() {
  return request({
    url: '/mes/qc/iqc/getIqcDictList/checkResult',
    method: 'get'
  })
}

export function getvoucherNoYear() {
  return request({
    url: '/mes/qc/iqc/getIqcDictList/voucherNoYear',
    method: 'get'
  })
}
export function getcheckStatus() {
  return request({
    url: '/mes/qc/iqc/getIqcDictList/checkStatus',
    method: 'get'
  })
}
export function getstatus() {
  return request({
    url: '/mes/qc/iqc/getIqcDictList/status',
    method: 'get'
  })
}