import request from "@/utils/request";

// 查询样品制作单列表
export function listProductionMake(query) {
  return request({
    url: "/mes/pro/productionMake/list",
    method: "get",
    params: query,
  });
}

// 查询样品制作单详细
export function getProductionMake(productionMakeId) {
  return request({
    url: "/mes/pro/productionMake/" + productionMakeId,
    method: "get",
  });
}

// 新增样品制作单
export function addProductionMake(data) {
  return request({
    url: "/mes/pro/productionMake",
    method: "post",
    data: data,
  });
}

// 修改样品制作单
export function updateProductionMake(data) {
  return request({
    url: "/mes/pro/productionMake",
    method: "put",
    data: data,
  });
}

// 删除样品制作单
export function delProductionMake(productionMakeId) {
  return request({
    url: "/mes/pro/productionMake/" + productionMakeId,
    method: "delete",
  });
}
// 修改状态
export function dofinish(data) {
  return request({
    url: "/mes/pro/productionMake/modifyState",
    method: "put",
    data: data,
  });
}
