import request from '@/utils/request'

// 查询尺码组明细列表
export function listItem(query) {
  return request({
    url: '/md/item/list',
    method: 'get',
    params: query
  })
}

// 查询尺码组明细详细
export function getItem(sizeGroupItemId) {
  return request({
    url: '/md/item/' + sizeGroupItemId,
    method: 'get'
  })
}

// 新增尺码组明细
export function addItem(data) {
  return request({
    url: '/md/item',
    method: 'post',
    data: data
  })
}

// 修改尺码组明细
export function updateItem(data) {
  return request({
    url: '/md/item',
    method: 'put',
    data: data
  })
}

// 删除尺码组明细
export function delItem(sizeGroupItemId) {
  return request({
    url: '/md/item/' + sizeGroupItemId,
    method: 'delete'
  })
}
